create or replace package body tbicds.PCK_PAT_TREATMENT is

/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
/*delete a treatment program*/
procedure DeleteTreatmentProgram( pi_vSessionID           in varchar2,
                           pi_vSessionClientIP     in varchar2,
                           pi_nUserID              in number,
                                
                           pi_nRegionID            in number,
                           pi_nSiteID              in number,
                           pi_vPatientID           in varchar2,
                           pi_nProgramID          in number,
                          
                           po_nStatusCode         out number,
                           po_vStatusComment      out varchar2
                          )
is
    v_nPatTreatmentID number := 0;
   
begin
  
    po_nStatusCode    := 0;
    po_vStatusComment := '';
   
    delete from tbicds.pat_treatment_program t 
    where t.program_id = pi_nProgramID;
    commit;


exception
    when others then
      rollback;
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*delete a treatment*/
procedure DeleteTreatment( pi_vSessionID           in varchar2,
                           pi_vSessionClientIP     in varchar2,
                           pi_nUserID              in number,
                                
                           pi_nRegionID            in number,
                           pi_nSiteID              in number,
                           pi_vPatientID           in varchar2,
                           pi_nTreatmentID         in number,
                          
                           po_nStatusCode         out number,
                           po_vStatusComment      out varchar2
                          )
is
    v_nPatTreatmentID number := 0;
   
begin
  
    po_nStatusCode    := 0;
    po_vStatusComment := '';
   
    delete from tbicds.pat_treatment_program t 
    where t.treatment_id = pi_nTreatmentID;
    commit;
    
    delete from tbicds.pat_treatment t 
    where t.treatment_id = pi_nTreatmentID;
    commit;


exception
    when others then
      rollback;
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;


/*update patient treatment program record*/
procedure UpdateTreatmentProgram( pi_vSessionID           in varchar2,
                           pi_vSessionClientIP     in varchar2,
                           pi_nUserID              in number,
                           pi_vPatientID           in varchar2,
                           pi_nTreatmentID         in number,
                           pi_nProgramID           in number,
                           
                           pi_nCPAID               in number, 
                           pi_dtInitialDate        in date,
                           pi_dtEndDate            in date,
                                
                           po_nStatusCode         out number,
                           po_vStatusComment      out varchar2
                          )
is
    v_nPatTreatmentID number := 0;
    
    v_vSQL long :=

        'update tbicds.pat_treatment_program
         set  INITIAL_DATE = :INITIAL_DATE,
              END_DATE = :END_DATE,
              CPA_ID = :CPA_ID
        where TREATMENT_ID = :TREATMENT_ID
          and PROGRAM_ID = :PROGRAM_ID 
          and PATIENT_ID = :PATEINT_ID
          ';
begin
  
    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    
    --execute the SQL
    execute immediate v_vSQL
    using pi_dtInitialDate,
          pi_dtEndDate,
          pi_nCPAID, 
          pi_nTreatmentID,
          pi_nProgramID,
          pi_vPatientID;  
           
    commit;


exception
    when others then
      rollback;
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;


/*update patient treatment record*/
procedure UpdateTreatment( pi_vSessionID           in varchar2,
                           pi_vSessionClientIP     in varchar2,
                           pi_nUserID              in number,
                           pi_vPatientID           in varchar2,
                           pi_nTreatmentID         in number,
                           
                           pi_nTreatmentType       in number, 
                           pi_vTreatmentTitle      in varchar2,
                           
                           pi_dtInitialDate        in date,
                           pi_dtEndDate            in date,
                                
                           po_nStatusCode         out number,
                           po_vStatusComment      out varchar2
                          )
is
    v_nPatTreatmentID number := 0;
    
    v_vSQL long :=

        'update tbicds.pat_treatment
         set  INITIAL_DATE = :INITIAL_DATE,
              END_DATE = :END_DATE,
              TREATMENT_TYPE_ID = :TREAT_TYPE,
              TREATMENT_TITLE = :TREAT_TITLE
        where TREATMENT_ID = :TREATMENT_ID
          and PATIENT_ID = :PATEINT_ID
          ';
begin
  
    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    
    --execute the SQL
    execute immediate v_vSQL
    using pi_dtInitialDate,
          pi_dtEndDate,
          pi_nTreatmentType,
          pi_vTreatmentTitle,
          pi_nTreatmentID,
          pi_vPatientID;  
           
    commit;


exception
    when others then
      rollback;
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;


/*get treatment rs by id*/
procedure GetTreatmentRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nTreatmentID           in long,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(4000) :=
      'SELECT  t.PATIENT_ID,
               t.TREATMENT_ID,
               t.REGION_ID,
               t.SITE_ID,
               t.INITIAL_DATE,
               t.END_DATE,
               t.TREATMENT_TITLE,
               t.TREATMENT_TYPE_ID,
               decode(t.TREATMENT_TYPE_ID, 
                      1, ''Outpatient'', 
                      2, ''Inpatient'', 
                      ''Unknown'') as TREATMENT_TYPE 
         FROM tbicds.PAT_TREATMENT t
        WHERE t.patient_id = :PATIENT_ID 
          AND t.treatment_id = :TREATMENT_ID ';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
     open rs 
      for v_vSQL
    using pi_vPatientID,
          pi_nTreatmentID;
    
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*get treatment program rs by program id*/
procedure GetTreatmentProgramRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nTreatmentID           in long,
      pi_nProgramID             in long,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(4000) :=
      'SELECT  t.PATIENT_ID,
               t.TREATMENT_ID,
               t.CPA_ID,
               t.REGION_ID,
               t.SITE_ID,
               t.INITIAL_DATE,
               t.END_DATE,
               t.PROGRAM_ID,
               t2.CPA_TITLE
         FROM tbicds.PAT_TREATMENT_PROGRAM t,
              tbicds.CPA t2
        WHERE t.patient_id = :PATIENT_ID 
          AND t.treatment_id = :TREATMENT_ID 
          AND t.program_id = :PROGRAM_ID 
          AND t2.CPA_ID = t.CPA_ID      
        ORDER BY t.INITIAL_DATE DESC';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
     open rs 
      for v_vSQL
    using pi_vPatientID,
          pi_nTreatmentID,
          pi_nProgramID;
    
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;


/*get treatment program rs by treatment id*/
procedure GetTreatmentProgramRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nTreatmentID           in long,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(4000) :=
      'SELECT  t.PATIENT_ID,
               t.TREATMENT_ID,
               t.CPA_ID,
               t.REGION_ID,
               t.SITE_ID,
               t.INITIAL_DATE,
               t.END_DATE,
               t.PROGRAM_ID,
               t2.CPA_TITLE
         FROM tbicds.PAT_TREATMENT_PROGRAM t,
              tbicds.CPA t2
        WHERE t.patient_id = :PATIENT_ID 
          AND t.treatment_id = :TREATMENT_ID 
          AND t2.CPA_ID = t.CPA_ID      
        ORDER BY t.INITIAL_DATE DESC';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
     open rs 
      for v_vSQL
    using pi_vPatientID,
          pi_nTreatmentID;
    
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*
gets a recordset of all treatments for this patient
*/
procedure GetTreatmentRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(4000) :=
      'SELECT  t.PATIENT_ID,
               t.TREATMENT_ID,
               t.TREATMENT_TYPE_ID,
               t.INITIAL_DATE,
               t.END_DATE,
               t.TREATMENT_TITLE,
               t.REGION_ID,
               t.SITE_ID,
               decode(t.TREATMENT_TYPE_ID, 
                      1, ''Outpatient'', 
                      2, ''Inpatient'', 
                      ''Unknown'') as TREATMENT_TYPE 
         FROM tbicds.PAT_TREATMENT t
        WHERE t.patient_id = :PATIENT_ID 
        ORDER BY t.INITIAL_DATE DESC';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
     open rs 
      for v_vSQL
    using pi_vPatientID;
    
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*
insert a new patient treatment
*/
procedure InsertTreatment( pi_vSessionID           in varchar2,
                           pi_vSessionClientIP     in varchar2,
                           pi_nUserID              in number,
                                
                           pi_nRegionID            in number,
                           pi_nSiteID              in number,
                           pi_vPatientID           in varchar2,
                          
                           pi_nTreatmentTypeID     in number,
                           pi_dtInitialDate        in date,
                           pi_dtEndDate            in date,
                           pi_vTreatmentTitle      in varchar2,
                                
                           po_nPatTreatmentID     out number,
                           po_nStatusCode         out number,
                           po_vStatusComment      out varchar2
                          )
is
    v_nPatTreatmentID number := 0;
    
    v_vSQL long :=

        'insert into tbicds.pat_treatment( PATIENT_ID,
                                           TREATMENT_ID,
                                           TREATMENT_TYPE_ID,
                                           INITIAL_DATE,
                                           END_DATE,
                                           TREATMENT_TITLE,
                                           REGION_ID,
                                           SITE_ID
                                         )
          values(:PATEINT_ID,
                 :TREATMENT_ID,
                 :TREATMENT_TYPE_ID,
                 :INITIAL_DATE,
                 :END_DATE,
                 :TREATMENT_TITLE,   
                 :REGION_ID,
                 :SITE_ID   
                 )';
begin
  
    po_nStatusCode    := 0;
    po_vStatusComment := '';
    po_nPatTreatmentID := 0;
    
    --get a new id
    select SEQ_PATTREATMENTID.nextval into v_nPatTreatmentID from dual;
    
    --execute the SQL
    execute immediate v_vSQL
    using pi_vPatientID,
          v_nPatTreatmentID,
          pi_nTreatmentTypeID,
          pi_dtInitialDate,
          pi_dtEndDate,
          pi_vTreatmentTitle,
          pi_nRegionID,
          pi_nSiteID
          ;  
           
    commit;

    --return the id
    po_nPatTreatmentID := v_nPatTreatmentID;
   

exception
    when others then
      rollback;
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;


/*
insert a new patient treatment program
*/
procedure InsertTreatmentProgram( pi_vSessionID           in varchar2,
                           pi_vSessionClientIP     in varchar2,
                           pi_nUserID              in number,
                                
                           pi_nRegionID            in number,
                           pi_nSiteID              in number,
                           
                           pi_vPatientID           in varchar2,
                           pi_nPatTreatmentID      in number,
                           pi_nCPAID               in number,
                                                      
                           pi_dtInitialDate        in date,
                           pi_dtEndDate            in date,
                          
                           po_nPatTreatProgID     out number,
                           po_nStatusCode         out number,
                           po_vStatusComment      out varchar2
                          )
is
    v_nPatTreatProgID number := 0;
    
    v_vSQL long :=

        'insert into tbicds.pat_treatment_program( PATIENT_ID,
                                                   TREATMENT_ID,
                                                   PROGRAM_ID,
                                                   CPA_ID,
                                                   INITIAL_DATE,
                                                   END_DATE,
                                                   REGION_ID,
                                                   SITE_ID
                                         )
          values(:PATEINT_ID,
                 :TREATMENT_ID,
                 :PROGRAM_ID,
                 :CPA_ID,
                 :INITIAL_DATE,
                 :END_DATE,
                 :REGION_ID,
                 :SITE_ID   
                 )';
begin
  
    po_nStatusCode    := 0;
    po_vStatusComment := '';
    po_nPatTreatProgID := 0;    
    
    --get a new id
    select SEQ_PATTREATPROGID.nextval into v_nPatTreatProgID from dual;
   
    --execute the SQL
    execute immediate v_vSQL
    using pi_vPatientID,
          pi_nPatTreatmentID,
          v_nPatTreatProgID,
          pi_nCPAID,
          pi_dtInitialDate,
          pi_dtEndDate,
          pi_nRegionID,
          pi_nSiteID
          ;  
           
    commit;

    --return the id
    po_nPatTreatProgID := v_nPatTreatProgID;
   

exception
    when others then
      rollback;
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

end PCK_PAT_TREATMENT;
/

